PROCEDURE CheckRecordLengthConversion;
{DEBUG}

CONST
	{$INCLUDE AP Source Code\GLOBAL_CONST 2023.px}

VAR
	{$INCLUDE AP Source Code\GLOBAL_VARS.px}
	MetricSym			:HANDLE;
	ImpSym				:HANDLE;
	TargetSym			:HANDLE;
	Str1				:STRING;
	Str2				:STRING;
	Sx, Sy				:REAL;
	OffSetX				:REAL;
	OffSetY				:REAL;
	SymName				:STRING;
	TargetX, TargetY	:REAL;
	TargetName			:STRING;
	TargetDef			:HANDLE;
	HasGraphic			:BOOLEAN;
	NumObjs				:INTEGER;
	LabelArray			:ARRAY[1..5] OF HANDLE;
	Old171				:LONGINT;
	Old172				:LONGINT;
	
	
(*
	major,minor,maintenance,platform	:INTEGER;
	Format					:INTEGER;
	Fraction,Display		:LONGINT;
	UPI						:REAL;
	UnitName,SquareName		:STRING;
*)
	
{=================================================================}

	{$INCLUDE AP Source Code\GLOBAL_PROCS SL.px}
	
{=================================================================}

	PROCEDURE CollectSelectedSymbol( obj : HANDLE );
			
	BEGIN
		ResetObject(obj);
		NumObjs := NumObjs + 1;
		LabelArray[NumObjs] := obj;
	END; {PROCEDURE CollectSelectedSymbols}
	
{=================================================================}

BEGIN
	GetUnits(Fraction, Display, Format, UPI, UnitName, SquareName);
	Old171 := GetPrefLongInt(171);
	Old172 := GetPrefLongInt(172);
	SetPrefLongInt(171, 6);
	SetPrefLongInt(172, 6);
	RedrawAll;
	SymName := 'Graphic Stamp';
	ForEachObject(CollectSelectedSymbol, ((VSEL=TRUE)));
	FOR Index := 1 TO NumObjs DO
		BEGIN
			TargetSym := LabelArray[Index];
			TargetName := GetSymName(TargetSym);
			TargetDef := GetObject(TargetName);
			GetSymLoc(TargetSym, TargetX, TargetY);
			HasGraphic := TestBooleanStr(GetRField(TargetSym, 'AP Tape Label Record', 'Has Graphic'));
			
			IF UPI = 1 THEN
				BEGIN
					Str1 := GetRField(TargetSym, 'AP Tape Label Record', 'Graphic Loc X');
					Str2 := GetRField(TargetSym, 'AP Tape Label Record', 'Graphic Loc Y');
				END
			ELSE
				BEGIN
					Str1 := GetRField(TargetSym, 'AP Tape Label Record', 'MGraphic Loc X');
					Str2 := GetRField(TargetSym, 'AP Tape Label Record', 'MGraphic Loc Y');
				END;
			OffSetX := Str2NumN(Str1);
			OffSetY := Str2NumN(Str2);

			Sx := TargetX + OffSetX;
			Sy := TargetY + OffSetY;
			Symbol(SymName,  Sx, Sy, 0);
			
			TargetSym := NextObj(TargetSym);
			
		END; {FOR Index := 1 TO NumObjs}
	RedrawAll;
	SetPrefLongInt(171, Old171);
	SetPrefLongInt(172, Old172);
END;
RUN(CheckRecordLengthConversion);


